/*
SQLyog Community Edition- MySQL GUI v6.0 Beta 1
Host - 4.1.9-max : Database - digitrack
*********************************************************************
Server version : 4.1.9-max
*/


/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

create database if not exists `digitrack`;

USE `digitrack`;

/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

/*Table structure for table `companies` */

DROP TABLE IF EXISTS `companies`;

CREATE TABLE `companies` (
  `company_id` int(11) NOT NULL auto_increment,
  `company_name` char(255) NOT NULL default '',
  `company_sector` char(255) NOT NULL default '',
  `company_count` int(11) NOT NULL default '0',
  PRIMARY KEY  (`company_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

/*Data for the table `companies` */

/*Table structure for table `events` */

DROP TABLE IF EXISTS `events`;

CREATE TABLE `events` (
  `event_id` int(11) NOT NULL auto_increment,
  `event_date` timestamp NULL default NULL,
  `user_id_users` int(11) default '0',
  `ressource_id_ressources` int(11) default '0',
  `hostname_hostnames` int(11) default '0',
  PRIMARY KEY  (`event_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `events` */

/*Table structure for table `hostnames` */

DROP TABLE IF EXISTS `hostnames`;

CREATE TABLE `hostnames` (
  `host_name` varchar(255) NOT NULL default '',
  `host_id` int(10) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`host_id`),
  UNIQUE KEY `hostname` (`host_name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

/*Data for the table `hostnames` */

insert  into `hostnames`(`host_name`,`host_id`) values ('internal.digimind.com',1),('internal2.digimind.com',4),('digi-tv.com',5);

/*Table structure for table `hosts_to_companies` */

DROP TABLE IF EXISTS `hosts_to_companies`;

CREATE TABLE `hosts_to_companies` (
  `company_id_companies` int(11) default '0',
  `hostname_hostnames` int(11) default '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

/*Data for the table `hosts_to_companies` */

/*Table structure for table `hosts_to_users` */

DROP TABLE IF EXISTS `hosts_to_users`;

CREATE TABLE `hosts_to_users` (
  `hostname_hostnames` int(11) default '0',
  `user_id_users` int(11) default '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

/*Data for the table `hosts_to_users` */

/*Table structure for table `ressources` */

DROP TABLE IF EXISTS `ressources`;

CREATE TABLE `ressources` (
  `ressource_id` int(11) NOT NULL auto_increment,
  `ressource_url` char(255) NOT NULL default '',
  `ressource_type` enum('pdf','html','ppt','doc','xls','other') NOT NULL default 'pdf',
  `creation_date` timestamp NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`ressource_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

/*Data for the table `ressources` */

/*Table structure for table `users` */

DROP TABLE IF EXISTS `users`;

CREATE TABLE `users` (
  `user_id` int(11) NOT NULL auto_increment,
  `creation_date` timestamp NOT NULL default '0000-00-00 00:00:00',
  `user_first_name` char(255) NOT NULL default '',
  `user_last_name` char(255) NOT NULL default '',
  `user_mail` char(255) NOT NULL default '',
  `user_address` char(255) NOT NULL default '',
  `user_country` char(255) NOT NULL default '',
  `user_company` char(255) NOT NULL default '',
  `user_service` char(255) NOT NULL default '',
  `user_title` char(32) NOT NULL default '',
  `user_sector` char(255) NOT NULL default '',
  `company_id_companies` int(11) default '0',
  PRIMARY KEY  (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

/*Data for the table `users` */

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
